#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Fractal mosaic 39Mod01.fsh   by Jarble   
//https://www.shadertoy.com/view/DsfcW4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 f1(vec2 a){
    return
        //fract(a)
        fract(a-fract(a*4.))
        //fract(a-fract(a*pow(floor(a.x),2.)))
        //abs(fract(a)+fract(a/16.)/16.)/(1.+1./16.)
        //mod(a*sign(1.-2.*mod(floor(a/2.),2.)),4.)
    ;
}

vec2 triangle_wave(vec2 a){
    vec2 a2 =
        vec2(1.,0.5)
        //-vec2(1.,0.5)
        //vec2(1.+sign(a.x)/2.,0.5-sign(a.x)/2.)
    ,
    a1 = a+a2;
    return
        abs(f1((a1)*(a2.x+a2.y))-.5)
    ;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor = vec4(0.0);
    vec3 col = vec3(0.);
    float t1 = .5*2.;
    vec2 uv = (fragCoord)/iResolution.y/1.5/t1;
    uv.x += (iTime/2.0,iTime/3.0)/t1/8.0;
    if(iMouse.z>.5)
    uv = uv.xy + iMouse.xy / iResolution.xy/t1;
    vec2 t2 = vec2(0.);
    bool b = true;
    uv.x = mod(uv.x,.25)+.25+.125;
    //uv.y = mod(uv.y,.5)+.25-.125;
    for(int k = 0; k < 4; k++){
        uv =
            abs(.5-uv-t2*sign(uv.y-uv.x))/1.5
        ;
        b = uv.y<uv.x;
        if(b) uv = uv.yx;
        t2 =
            triangle_wave(uv-.5*sign(uv.x-uv.y)).yx
        ;
        uv =
            t2-triangle_wave(uv.yx).yx
        ;
        col.x =
            max(sign(uv.x),col.x)
            //abs(sign(uv.x)-col.x)/2.
        ;
        
        //awesome kaleidoscope effect!
        //if(t2.y>t2.x) {t2 = t2.yx; uv=uv.yx-iTime/8.;}
        
        col.xyz =
            abs(col.yzx-float(b)/2.)
        ;
        //if(uv.y < .5) uv.y += .5;
    }
    if (!b) col = abs(1.-col);
    fragColor = vec4(min(col,vec3(1.)),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

